# 機能設計書 50-Kerberos 5（Heimdal）

## 概要

本ドキュメントは、FreeBSDに同梱されるKerberos V認証プロトコルの実装であるHeimdalについて記述する。Heimdalはスウェーデン王立工科大学（KTH）で開発されたKerberos 5実装であり、認証サービス、チケット管理、および関連ユーティリティを提供する。

### 本機能の処理概要

Heimdal Kerberos 5はネットワーク認証プロトコルの実装であり、信頼できる第三者（KDC: Key Distribution Center）を介してクライアント-サーバ間の相互認証を提供する。

**業務上の目的・背景**：エンタープライズ環境でのシングルサインオン（SSO）、ネットワークサービスの安全な認証、Active Directoryとの認証連携において、Kerberos 5プロトコルは業界標準として広く使用されている。パスワードをネットワーク上に送信することなく安全な認証を実現する。

**機能の利用シーン**：KDC（Key Distribution Center）の運用、ユーザ認証（kinit/kinitによるチケット取得）、サービスチケットの取得と提示、Kerberos認証を用いたSSH/NFS/LDAP等のサービス利用、Active Directory環境との認証連携、GSSAPI経由のアプリケーション認証に使用される。

**主要な処理内容**：
1. KDCデーモン（kdc）による認証サービス（AS: Authentication Service）
2. KDCによるチケット付与サービス（TGS: Ticket-Granting Service）
3. kinitによるTGT（Ticket-Granting Ticket）取得
4. klistによるチケットキャッシュの表示
5. kdestroyによるチケットの破棄
6. kadminによるKerberosデータベースの管理
7. kpasswdによるパスワード変更
8. ktutilによるキータブファイルの管理
9. GSSAPIライブラリによるアプリケーション認証サポート

**関連システム・外部連携**：PAM（Pluggable Authentication Modules）との統合、OpenSSHのGSSAPI認証、NFS Kerberosセキュリティ、LDAP/Active Directory連携、DNS SRVレコードによるKDC自動検出。

**権限による制御**：kinitは一般ユーザが実行可能。kadminの管理操作はKerberos管理者権限が必要。KDCデーモンの起動にはroot権限が必要。キータブファイル（/etc/krb5.keytab）のアクセスはroot権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | （CLIベースのためGUI画面なし） | - | kinit/klist/kdestroy/kadmin等のコマンドによる操作 |

## 機能種別

ネットワーク認証 / チケット管理 / 鍵配布 / シングルサインオン

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| principal | string | Yes（認証時） | Kerberosプリンシパル名（user@REALM） | 有効なプリンシパル形式 |
| password | string | Yes（AS認証時） | ユーザパスワード | KDC側で検証 |
| realm | string | No | Kerberosレルム名 | 有効なレルム名 |
| keytab | string | No | キータブファイルパス | 読み取り可能なファイル |
| service | string | No | サービスプリンシパル（host/hostname@REALM等） | 有効なサービスプリンシパル形式 |
| ticket_cache | string | No | チケットキャッシュファイルパス | 書き込み可能なパス |

### 入力データソース

- コマンドライン入力（kinit/kadmin等）
- /etc/krb5.conf設定ファイル
- キータブファイル（/etc/krb5.keytab）
- KDCデータベース（HDB: Heimdal Database）
- DNS SRVレコード（KDC自動検出）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| TGT | Kerberos ticket | チケット付与チケット |
| service_ticket | Kerberos ticket | サービスチケット |
| session_key | byte[] | セッション鍵 |
| ticket_list | text | チケットキャッシュ内容一覧 |
| admin_output | text | kadmin管理操作の結果 |

### 出力先

- チケットキャッシュファイル（/tmp/krb5cc_*）
- 標準出力（klist, kadmin等の結果表示）
- KDCデータベース（kadmin操作時）
- syslog（KDCログ）

## 処理フロー

### 処理シーケンス

```
1. kinit: TGT取得
   └─ AS-REQ → KDC → AS-REP（暗号化TGT）→ ユーザパスワードで復号
2. サービスアクセス時のチケット取得
   └─ TGS-REQ（TGT付き）→ KDC → TGS-REP（サービスチケット）
3. サービスへの認証
   └─ AP-REQ（サービスチケット付き）→ サーバ → AP-REP（相互認証）
4. kadmin: データベース管理
   └─ kadminクライアント → kadmindデーモン → HDB操作
5. kpasswd: パスワード変更
   └─ kpasswdクライアント → kpasswddデーモン → HDB更新
```

### フローチャート

```mermaid
flowchart TD
    A[クライアント: kinit] --> B[AS-REQ → KDC]
    B --> C[KDC: プリンシパル検証]
    C --> D[AS-REP: 暗号化TGT返却]
    D --> E[クライアント: パスワードで復号]
    E --> F[TGTをキャッシュに保存]

    G[サービスアクセス要求] --> H[TGS-REQ: TGT提示 → KDC]
    H --> I[KDC: TGT検証]
    I --> J[TGS-REP: サービスチケット返却]
    J --> K[AP-REQ: サービスチケット提示 → サーバ]
    K --> L[サーバ: チケット検証]
    L --> M[AP-REP: 相互認証完了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-50-01 | チケット有効期限 | TGTおよびサービスチケットには有効期限があり、期限切れ後は再取得が必要 | チケット使用時 |
| BR-50-02 | レルム信頼関係 | 異なるレルム間の認証にはクロスレルム信頼関係の設定が必要 | クロスレルム認証時 |
| BR-50-03 | 事前認証 | セキュリティ強化のためAS-REQ時に事前認証（PA-DATA）が要求される場合がある | KDCポリシー設定 |
| BR-50-04 | チケット更新 | 更新可能フラグが設定されたチケットは有効期限内に更新可能 | kinit -R |

### 計算ロジック

- チケット暗号化：プリンシパルの鍵（パスワード由来または長期鍵）によるチケットの暗号化
- セッション鍵生成：ランダムなセッション鍵の生成
- 鍵導出：パスワードからの暗号鍵導出（string2key関数）

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象データ構造 | 操作種別 | 概要 |
|-----|-------------|---------|------|
| kadmin add | HDB（Heimdal Database） | INSERT | プリンシパル追加 |
| kadmin modify | HDB | UPDATE | プリンシパル属性変更 |
| kadmin delete | HDB | DELETE | プリンシパル削除 |
| kadmin list | HDB | SELECT | プリンシパル一覧 |
| kpasswd | HDB | UPDATE | パスワード（鍵）変更 |
| kinit | ticket cache | INSERT | チケットキャッシュにTGT保存 |

### テーブル別操作詳細

#### HDB（Heimdal Database）

| 操作 | 項目 | 更新値・取得条件 | 備考 |
|-----|------|-----------------|------|
| INSERT | principal, keys, kvno, expiration | kadmin add時 | プリンシパル名で一意 |
| UPDATE | keys, kvno, password_expiration | kpasswd/kadmin modify時 | kvno（Key Version Number）をインクリメント |
| SELECT | principal | AS-REQ/TGS-REQ処理時 | プリンシパル名で検索 |
| DELETE | principal | kadmin delete時 | 関連するすべての鍵データも削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| KRB5KDC_ERR_C_PRINCIPAL_UNKNOWN | プリンシパル不明 | 存在しないプリンシパルでの認証 | プリンシパルをKDCに追加 |
| KRB5KDC_ERR_PREAUTH_FAILED | 事前認証失敗 | パスワード不正 | 正しいパスワードを入力 |
| KRB5KRB_AP_ERR_TKT_EXPIRED | チケット期限切れ | TGTまたはサービスチケットの有効期限超過 | kinitで新しいTGTを取得 |
| KRB5_KT_NOTFOUND | キータブエントリ不在 | キータブに該当プリンシパルがない | ktutilでキータブに追加 |
| KRB5KRB_AP_ERR_SKEW | 時刻ずれ | クライアント/サーバ間の時刻差が許容範囲外 | NTPで時刻同期 |

### リトライ仕様

KDC通信失敗時は他のKDCサーバへのフェイルオーバーが行われる（krb5.conf内の複数KDC指定時）。

## トランザクション仕様

KDCの認証処理は個別のリクエスト/レスポンス単位で完結する。HDBへのプリンシパル追加・変更はデータベースバックエンドのトランザクション機能に依存する。

## パフォーマンス要件

- AS-REQ/AS-REPの応答時間：暗号処理を含むため10ms-100ms程度
- TGS-REQ/TGS-REPの応答時間：TGT検証と暗号処理を含む
- KDCのスケーラビリティ：HDBデータベースの効率的なルックアップ
- チケットキャッシュの高速アクセス

## セキュリティ考慮事項

- KDCサーバの物理的・論理的セキュリティの確保（KDCの侵害は全体の侵害）
- KDCデータベースの暗号化バックアップ
- 弱い暗号タイプ（DES, RC4-HMAC）の無効化
- 時刻同期の重要性（Kerberosは時刻ベースの攻撃防止に依存）
- キータブファイルのアクセス制御（rootのみ読み取り可能）
- チケットキャッシュファイルのパーミッション管理

## 備考

- HeimdalはFreeBSDのベースシステムに含まれるKerberos 5実装
- MIT Kerberos 5は別の実装であり、FreeBSDではportsから利用可能
- GSSAPIライブラリ（libgssapi）はKerberosを含むセキュリティメカニズムの抽象化層
- crypto/heimdal/配下にHeimdal本体のソースツリーが含まれる
- kerberos5/配下にFreeBSD統合用のビルドインフラストラクチャがある

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Kerberosプロトコルの基本データ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | krb5.h | `kerberos5/include/krb5.h` | Kerberos 5の型定義、プリンシパル構造体、チケット構造体 |
| 1-2 | hdb.h | `crypto/heimdal/lib/hdb/hdb.h` | HDB（Heimdal Database）のデータベースインタフェース定義 |

**読解のコツ**: Kerberos 5のプロトコルメッセージはASN.1で定義されている。Heimdalはasn1コンパイラで生成したコードを使用する。krb5_principal, krb5_ticket, krb5_creds等の型がプロトコル要素に対応する。

#### Step 2: KDC実装を理解する

Key Distribution Centerの処理フローを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | kdc/ | `crypto/heimdal/kdc/` | KDCデーモンの実装。AS-REQ処理、TGS-REQ処理のメインフロー |

**主要処理フロー**:
- AS-REQ受信 → プリンシパル検証 → 事前認証チェック → TGT生成・暗号化 → AS-REP送信
- TGS-REQ受信 → TGT復号・検証 → サービスチケット生成 → TGS-REP送信

#### Step 3: クライアントライブラリを理解する

libkrb5のクライアント側APIを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | lib/krb5/ | `crypto/heimdal/lib/krb5/` | Kerberos 5クライアントライブラリ。krb5_init_creds, krb5_get_credentials等の主要API |

#### Step 4: ユーザ空間ツールを理解する

主要コマンドのエントリーポイントを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | kinit/ | `kerberos5/usr.bin/` | kinitコマンド。TGT取得のユーザインタフェース |
| 4-2 | kadmin/ | `kerberos5/usr.sbin/` | kadminコマンド。KDCデータベース管理ツール |

#### Step 5: GSSAPIを理解する

GSSAPI抽象化層を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | lib/gssapi/ | `crypto/heimdal/lib/gssapi/` | GSSAPIライブラリ。Kerberosメカニズムの実装 |

### プログラム呼び出し階層図

```
ユーザ空間ツール
    │
    ├─ kinit → libkrb5 → AS-REQ/AS-REP
    │      └─ チケットキャッシュに保存
    │
    ├─ klist → チケットキャッシュ読み取り
    │
    ├─ kdestroy → チケットキャッシュ削除
    │
    ├─ kadmin → kadmindデーモン → HDB操作
    │
    ├─ kpasswd → kpasswddデーモン → HDB鍵更新
    │
    └─ アプリケーション → GSSAPI → libkrb5
           └─ TGS-REQ/TGS-REP → AP-REQ/AP-REP

KDCデーモン
    │
    ├─ AS（Authentication Service）
    │      └─ AS-REQ処理 → HDB検索 → AS-REP返却
    │
    └─ TGS（Ticket-Granting Service）
           └─ TGS-REQ処理 → TGT検証 → TGS-REP返却
```

### データフロー図

```
[入力]                    [処理]                         [出力]

kinit ユーザ名 ────▶ libkrb5: AS-REQ生成 ──▶ KDC: AS-REP
(パスワード入力)       ────────────────────────  (暗号化TGT)
                      パスワードで復号 ────────▶ チケットキャッシュ

サービスアクセス ──▶ libkrb5: TGS-REQ生成 ──▶ KDC: TGS-REP
(TGT提示)            ────────────────────────  (サービスチケット)
                     AP-REQ生成 ─────────────▶ サーバ: AP-REP

kadmin操作 ────────▶ kadmind ──────────────▶ HDB更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| kdc/ | `crypto/heimdal/kdc/` | ソース | KDCデーモン実装 |
| lib/krb5/ | `crypto/heimdal/lib/krb5/` | ソース | Kerberos 5クライアントライブラリ |
| lib/hdb/ | `crypto/heimdal/lib/hdb/` | ソース | Heimdalデータベースライブラリ |
| lib/gssapi/ | `crypto/heimdal/lib/gssapi/` | ソース | GSSAPIライブラリ |
| lib/asn1/ | `crypto/heimdal/lib/asn1/` | ソース | ASN.1エンコーダ/デコーダ |
| lib/kadm5/ | `crypto/heimdal/lib/kadm5/` | ソース | kadmin管理ライブラリ |
| appl/ | `crypto/heimdal/appl/` | ソース | Kerberosアプリケーション |
| admin/ | `crypto/heimdal/admin/` | ソース | 管理ツール |
| tools/ | `crypto/heimdal/tools/` | ソース | ユーティリティツール |
| include/ | `kerberos5/include/` | ヘッダ | FreeBSD統合ヘッダ |
| usr.bin/ | `kerberos5/usr.bin/` | ソース | ユーザコマンド（kinit/klist/kdestroy等） |
| usr.sbin/ | `kerberos5/usr.sbin/` | ソース | 管理コマンド（kadmind/kdc/kpasswdd等） |
| lib/ | `kerberos5/lib/` | ソース | FreeBSD統合ライブラリビルド |
| libexec/ | `kerberos5/libexec/` | ソース | ヘルパープログラム |
| Makefile | `kerberos5/Makefile` | ビルド | FreeBSD統合ビルドシステム |
| Makefile.inc | `kerberos5/Makefile.inc` | ビルド | 共通ビルド設定 |
